import React from 'react';
import { Mail, ExternalLink } from 'lucide-react';

const EmailOpener = ({ subject, body, recipient = '' }) => {
  // Add branding to the email body
  const emailBodyWithBranding = `${body}

---
Generated by EmailCurator AI: https://openpromote.uinfo.org`;

  const openInGmail = () => {
    // Construct proper Gmail compose URL
    const baseUrl = 'https://mail.google.com/mail/u/0/#inbox';
    const params = new URLSearchParams({
      compose: 'new',
      to: recipient,
      subject: subject,
      body: emailBodyWithBranding
    });
    
    // Gmail uses a different format
    const gmailUrl = `https://mail.google.com/mail/?view=cm&fs=1&to=${encodeURIComponent(recipient)}&subject=${encodeURIComponent(subject)}&body=${encodeURIComponent(emailBodyWithBranding)}`;
    window.open(gmailUrl, '_blank');
  };

  const openInDefaultMail = () => {
    const mailtoUrl = `mailto:${recipient}?subject=${encodeURIComponent(subject)}&body=${encodeURIComponent(emailBodyWithBranding)}`;
    window.location.href = mailtoUrl;
  };

  return (
    <div className="mt-6 pt-6 border-t border-white/20">
      <div className="flex gap-3 justify-center">
        <button
          onClick={openInGmail}
          className="flex items-center gap-2 px-4 py-2 rounded-xl bg-white/20 hover:bg-white/30 text-white transition-all duration-300 border border-white/30"
          title="Open in Gmail"
        >
          <Mail className="h-4 w-4" />
          Open in Gmail
        </button>
        <button
          onClick={openInDefaultMail}
          className="flex items-center gap-2 px-4 py-2 rounded-xl bg-white/20 hover:bg-white/30 text-white transition-all duration-300 border border-white/30"
          title="Open in default mail app"
        >
          <ExternalLink className="h-4 w-4" />
          Open in Mail App
        </button>
      </div>
    </div>
  );
};

export default EmailOpener;