// app/api/auth/me/route.js
import { NextResponse } from 'next/server';
import { sessionDb } from '@/lib/database';

export async function GET(request) {
  try {
    const sessionToken = request.cookies.get('session_token')?.value;
    console.log('[API/ME] Cookies received:', request.cookies.getAll());
    console.log('[API/ME] Session token:', sessionToken);

    if (!sessionToken) {
      console.log('[API/ME] No session token found');
      return NextResponse.json({ error: 'No session' }, { status: 401 });
    }

    // Find session (now async)
    const session = await sessionDb.findValid(sessionToken);
    console.log('[API/ME] Session found:', session ? 'Yes' : 'No', session);

    if (!session) {
      console.log('[API/ME] Session invalid or not found in DB');
      return NextResponse.json({ error: 'Invalid session' }, { status: 401 });
    }

    return NextResponse.json({
      user: {
        id: session.id,
        name: session.name,
        email: session.email,
        company: session.company,
        job_title: session.job_title
      }
    });
  } catch (error) {
    console.error('Auth check error:', error);
    return NextResponse.json({ error: 'Internal server error' }, { status: 500 });
  }
}